<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <title>Testa Rezultāts</title>
    <style>
        h1 {
            text-align: center;
            margin-top: 20px;
            font-size: 24px;
        }
        .result-container {
            text-align: center;
            margin: 50px auto;
            padding: 20px;
            background-color: #f9f9f9;
            border: 1px solid #ccc;
            border-radius: 10px;
            width: 50%;
            box-shadow: 0px 0px 10px rgba(0, 0, 0, 0.1);
        }

        .result-container h2 {
            font-size: 28px;
            margin-bottom: 20px;
        }

        .result-container p {
            font-size: 22px;
            margin-bottom: 20px;
        }

        .result-container .score {
            font-weight: bold;
            color: #333;
        }

        .result-container .redirect-btn {
            cursor: pointer;
            background-color: #333;
            color: white;
            border: none;
            font-size: 18px;
            padding: 10px 20px;
            border-radius: 5px;
            transition: background-color 0.3s ease;
        }

        .result-container .redirect-btn:hover {
            background-color: #555;
        }
    </style>
    <script>
        function redirectToList() {
            window.location.href = 'list_tests.php';
        }
    </script>
</head>
<body>
    <?php
    // Detaļas par datu bāzes savienojumu
    $servername = "localhost";
    $username = "root";
    $password = "";
    $dbname = "quiz_db";

    // Izveido savienojumu
    $conn = new mysqli($servername, $username, $password, $dbname);

    // Pārbauda savienojumu
    if ($conn->connect_error) {
        die("Savienojums neizdevās: " . $conn->connect_error);
    }

    // Sāk sesiju
    session_start();

    if ($_SERVER["REQUEST_METHOD"] == "POST") {
        // Iegūst testa ID no formas
        $test_id = isset($_POST['test_id']) ? $_POST['test_id'] : null;

        // Iegūst lietotāja ID no sesijas
        $user_id = isset($_SESSION['user_id']) ? $_SESSION['user_id'] : null;

        // Aprēķina kopējo rezultātu un jautājumu skaitu
        list($total_score, $total_questions) = calculateTotalScore($_POST['answers']); 

        // Pārbauda, vai kopējais rezultāts nav null
        if ($total_score !== null) {
            // Ievieto testa rezultātu datu bāzē
            $sql_insert_result = "INSERT INTO test_results (test_id, user_id, score) VALUES (?, ?, ?)";
            $stmt = $conn->prepare($sql_insert_result);

            // Pārbauda, vai vaicājums tika sagatavots veiksmīgi
            if ($stmt) {
                $stmt->bind_param("iii", $test_id, $user_id, $total_score); 

                // Izpilda vaicājumu
                if ($stmt->execute()) {
                    // Parāda veiksmes ziņojumu
                    echo "<div class='result-container'>";
                    echo "<h2>Testa rezultāts veiksmīgi iesniegts</h2>";
                    echo "<p>Kopējais rezultāts: <span class='score'>$total_score no $total_questions</span></p>";
                    echo "<button class='redirect-btn' onclick='redirectToList()'>Atpakaļ uz testu sarakstu</button>";
                    echo "</div>";
                    exit(); // Aptur turpmāko izpildi
                } else {
                    echo "Kļūda iesniedzot testa rezultātu: " . $stmt->error;
                }
            } else {
                echo "Kļūda sagatavojot vaicājumu: " . $conn->error;
            }
        } else {
            echo "Kļūda: Kopējais rezultāts ir null.";
        }
    }

    // Funkcija, lai aprēķinātu kopējo rezultātu pamatojoties uz atbildēm
    function calculateTotalScore($answers) {
        $totalScore = 0;

       // Datu bāzes savienojuma detaļas
$servername = "localhost";
$username = "root";
$password = "";
$dbname = "quiz_db";

// Izveido savienojumu
$conn = new mysqli($servername, $username, $password, $dbname);

// Pārbauda savienojumu
if ($conn->connect_error) {
    die("Savienojums neizdevās: " . $conn->connect_error);
}

// Iegūst pareizās atbildes no datu bāzes
$sql = "SELECT * FROM answers WHERE is_correct = 1";
$result = $conn->query($sql);

$correctAnswers = array();
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $correctAnswers[] = $row['id'];
    }
} else {
    echo "Datubāzē nav atrastas pareizās atbildes.";
    return array(null, 0);
}

$totalQuestions = count($answers); // Kopējais jautājumu skaits

// Pārbauda, vai $answers ir masīvs
if (is_array($answers)) {
    // Iterē caur katru izvēlēto atbildi
    foreach ($answers as $question_id => $selectedAnswerId) {
        // Pārbauda, vai izvēlētā atbildes ID ir pareizās atbildes masīvā
        if (in_array($selectedAnswerId, $correctAnswers)) {
            // Pievieno 1 punktu kopējam rezultātam par katru pareizo atbildi
            $totalScore++;
        }
    }
}

// Aizver savienojumu
$conn->close();

return array($totalScore, $totalQuestions);

    }

    // Aizver savienojumu
$conn->close();

    ?>
</body>
</html>
